/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.hooks.ServerLevelExt;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.world_modification.BiomeBuffer;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3558;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7477;
import net.minecraft.class_7924;
import net.minecraft.class_8212;
import net.minecraft.server.MinecraftServer;

public class AxiomServerboundSetBuffer
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = new class_2960("axiom:set_buffer");
    private final class_5321<class_1937> world;
    private final BlockOrBiomeBuffer buffer;
    private final class_2540 rawByteBuf;

    public AxiomServerboundSetBuffer(class_5321<class_1937> world, BlockOrBiomeBuffer buffer) {
        this.world = world;
        this.buffer = buffer;
        this.rawByteBuf = null;
    }

    public AxiomServerboundSetBuffer(class_2540 friendlyByteBuf) {
        this.world = null;
        this.buffer = null;
        this.rawByteBuf = friendlyByteBuf;
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    public static AxiomServerboundSetBuffer read(class_2540 friendlyByteBuf) {
        BlockOrBiomeBuffer buffer;
        byte type2;
        class_5321 world = friendlyByteBuf.method_44112(class_7924.field_41223);
        friendlyByteBuf.method_10790();
        boolean continuation = friendlyByteBuf.readBoolean();
        if (!continuation) {
            friendlyByteBuf.method_10798();
        }
        if ((type2 = friendlyByteBuf.readByte()) == 0) {
            buffer = BlockBuffer.loadRaw(friendlyByteBuf);
        } else if (type2 == 1) {
            buffer = BiomeBuffer.load(friendlyByteBuf);
        } else {
            throw new RuntimeException("Unknown buffer type: " + type2);
        }
        return new AxiomServerboundSetBuffer((class_5321<class_1937>)world, buffer);
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.writeBytes((ByteBuf)this.rawByteBuf);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (AxiomServerboundPacket.isMissingPermission(server, player)) {
            return;
        }
        class_3218 level = server.method_3847(this.world);
        if (level == null) {
            return;
        }
        BlockOrBiomeBuffer blockOrBiomeBuffer = this.buffer;
        if (blockOrBiomeBuffer instanceof BlockBuffer) {
            BlockBuffer blockBuffer = (BlockBuffer)blockOrBiomeBuffer;
            AxiomServerboundSetBuffer.applyBlockBufferServer(blockBuffer, level);
        } else {
            blockOrBiomeBuffer = this.buffer;
            if (blockOrBiomeBuffer instanceof BiomeBuffer) {
                BiomeBuffer biomeBuffer = (BiomeBuffer)blockOrBiomeBuffer;
                AxiomServerboundSetBuffer.applyBiomeBufferServer(biomeBuffer, level);
            } else {
                throw new RuntimeException("Unknown buffer type: " + String.valueOf(this.buffer.getClass()));
            }
        }
    }

    public static void sendMulti(class_5321<class_1937> world, BlockOrBiomeBuffer buffer, class_2487 sourceInfo) {
        int sortChunkZ;
        int sortChunkY;
        int sortChunkX;
        UUID uuid = UUID.randomUUID();
        int maxSize = Axiom.getInstance().serverConfig.setBufferMaxSize() - 64;
        boolean firstChunk = true;
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_44116(world);
        buf.method_10797(uuid);
        buf.writeBoolean(false);
        buf.method_10794(sourceInfo);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            sortChunkX = player.method_31477() >> 4;
            sortChunkY = player.method_31478() >> 4;
            sortChunkZ = player.method_31479() >> 4;
        } else {
            sortChunkX = 0;
            sortChunkY = 0;
            sortChunkZ = 0;
        }
        if (buffer instanceof BlockBuffer) {
            BlockBuffer blockBuffer = (BlockBuffer)buffer;
            buf.writeByte(0);
            ArrayList<Long2ObjectMap.Entry<class_2841<class_2680>>> entries = new ArrayList<Long2ObjectMap.Entry<class_2841<class_2680>>>((Collection<Long2ObjectMap.Entry<class_2841<class_2680>>>)blockBuffer.entrySet());
            entries.sort(Comparator.comparingLong(entry -> {
                long pos = entry.getLongKey();
                int posX = class_2338.method_10061((long)pos);
                int posY = class_2338.method_10071((long)pos);
                int posZ = class_2338.method_10083((long)pos);
                return Math.abs(posX - sortChunkX) + Math.abs(posY - sortChunkY) + Math.abs(posZ - sortChunkZ);
            }));
            for (Long2ObjectMap.Entry entry2 : entries) {
                class_2841 container = (class_2841)entry2.getValue();
                int beforeWriterIndex = buf.writerIndex();
                buf.writeLong(entry2.getLongKey());
                container.method_12325(buf);
                Short2ObjectMap<CompressedBlockEntity> blockEntities = blockBuffer.getBlockEntityChunkMap(entry2.getLongKey());
                if (blockEntities != null) {
                    buf.method_10804(blockEntities.size());
                    for (Short2ObjectMap.Entry entry22 : blockEntities.short2ObjectEntrySet()) {
                        buf.writeShort((int)entry22.getShortKey());
                        ((CompressedBlockEntity)entry22.getValue()).write(buf);
                    }
                } else {
                    buf.method_10804(0);
                }
                if (buf.writerIndex() >= maxSize) {
                    if (firstChunk) {
                        Axiom.dbg("AxiomServerboundSetBuffer - Warning: More than " + NumberFormat.getInstance().format(maxSize) + " bytes in a single section. Forcing send...");
                        buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                        new AxiomServerboundSetBuffer(buf).send();
                        buf = new class_2540(Unpooled.buffer());
                        buf.method_44116(world);
                        buf.method_10797(uuid);
                        buf.writeBoolean(true);
                        buf.writeByte(0);
                        continue;
                    }
                    int copiedSize = buf.writerIndex() - beforeWriterIndex;
                    byte[] copied = new byte[copiedSize];
                    buf.getBytes(beforeWriterIndex, copied);
                    buf.writerIndex(beforeWriterIndex);
                    buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                    new AxiomServerboundSetBuffer(buf).send();
                    buf = new class_2540(Unpooled.buffer());
                    buf.method_44116(world);
                    buf.method_10797(uuid);
                    buf.writeBoolean(true);
                    buf.writeByte(0);
                    buf.writeBytes(copied);
                    firstChunk = true;
                    continue;
                }
                firstChunk = false;
            }
            buf.writeLong(PositionUtils.MIN_POSITION_LONG);
        } else if (buffer instanceof BiomeBuffer) {
            BiomeBuffer biomeBuffer = (BiomeBuffer)buffer;
            buf.writeByte(1);
            ArrayList<Long2ObjectMap.Entry> entries = new ArrayList<Long2ObjectMap.Entry>((Collection<Long2ObjectMap.Entry>)biomeBuffer.map.map.long2ObjectEntrySet());
            entries.sort(Comparator.comparingLong(entry -> {
                long pos = entry.getLongKey();
                int posX = class_2338.method_10061((long)pos);
                int posY = class_2338.method_10071((long)pos);
                int posZ = class_2338.method_10083((long)pos);
                return Math.abs(posX - sortChunkX) + Math.abs(posY - sortChunkY) + Math.abs(posZ - sortChunkZ);
            }));
            buf.writeByte(biomeBuffer.paletteSize);
            for (int i = 0; i < biomeBuffer.paletteSize; ++i) {
                buf.method_44116(biomeBuffer.palette[i]);
            }
            buf.writeByte(0);
            for (Long2ObjectMap.Entry entry3 : entries) {
                if ((long)(buf.writerIndex() + 4096) + 8L + 8L >= (long)maxSize) {
                    buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                    new AxiomServerboundSetBuffer(buf).send();
                    buf = new class_2540(Unpooled.buffer());
                    buf.method_44116(world);
                    buf.method_10797(uuid);
                    buf.writeBoolean(true);
                    buf.writeByte(1);
                    buf.writeByte(biomeBuffer.paletteSize);
                    for (int i = 0; i < biomeBuffer.paletteSize; ++i) {
                        buf.method_44116(biomeBuffer.palette[i]);
                    }
                    buf.writeByte(0);
                }
                buf.writeLong(entry3.getLongKey());
                buf.writeBytes((byte[])entry3.getValue());
            }
            buf.writeLong(PositionUtils.MIN_POSITION_LONG);
        } else {
            throw new RuntimeException("Unknown buffer type: " + String.valueOf(buffer.getClass()));
        }
        new AxiomServerboundSetBuffer(buf).send();
    }

    private static void applyBlockBufferServer(BlockBuffer buffer, class_3218 world) {
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_2680 emptyState = BlockBuffer.EMPTY_STATE;
        boolean hasStarlight = FabricLoader.getInstance().isModLoaded("starlight");
        for (Long2ObjectMap.Entry entry : buffer.entrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey());
            int cy = class_2338.method_10071((long)entry.getLongKey());
            int cz = class_2338.method_10083((long)entry.getLongKey());
            class_2841 container = (class_2841)entry.getValue();
            if (cy < world.method_32891() || cy >= world.method_31597()) continue;
            class_2818 chunk = world.method_8497(cx, cz);
            class_2826 section = chunk.method_38259(world.method_31603(cy));
            class_2841 sectionStates = section.method_12265();
            boolean hasOnlyAir = section.method_38292();
            class_2902 worldSurface = null;
            class_2902 oceanFloor = null;
            class_2902 motionBlocking = null;
            class_2902 motionBlockingNoLeaves = null;
            for (Map.Entry heightmap : chunk.method_12011()) {
                switch ((class_2902.class_2903)heightmap.getKey()) {
                    case field_13202: {
                        worldSurface = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13200: {
                        oceanFloor = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13197: {
                        motionBlocking = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13203: {
                        motionBlockingNoLeaves = (class_2902)heightmap.getValue();
                        break;
                    }
                }
            }
            short[] lightUpdates = hasStarlight ? null : ((ServerLevelExt)world).axiom$getPendingLightUpdates(cx, cy, cz);
            boolean sectionChanged = false;
            boolean relightStarlight = false;
            boolean containerMaybeHasPoi = container.method_19526(class_7477::method_46397);
            boolean sectionMaybeHasPoi = section.method_19523(class_7477::method_46397);
            Short2ObjectMap<CompressedBlockEntity> blockEntityChunkMap = buffer.getBlockEntityChunkMap(entry.getLongKey());
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                        if (blockState == emptyState) continue;
                        int bx = cx * 16 + x;
                        int by = cy * 16 + y;
                        int bz = cz * 16 + z;
                        if (hasOnlyAir && blockState.method_26215()) continue;
                        class_2248 block = blockState.method_26204();
                        class_2680 old = section.method_12256(x, y, z, blockState, true);
                        if (blockState != old) {
                            Optional oldPoi;
                            sectionChanged = true;
                            blockPos.method_10103(bx, by, bz);
                            motionBlocking.method_12597(x, by, z, blockState);
                            motionBlockingNoLeaves.method_12597(x, by, z, blockState);
                            oceanFloor.method_12597(x, by, z, blockState);
                            worldSurface.method_12597(x, by, z, blockState);
                            if (class_3558.method_51561((class_1922)chunk, (class_2338)blockPos, (class_2680)old, (class_2680)blockState)) {
                                if (hasStarlight) {
                                    relightStarlight = true;
                                } else {
                                    chunk.method_12018().method_51536((class_1922)chunk, x, by, z);
                                    int n = y + z * 16;
                                    lightUpdates[n] = (short)(lightUpdates[n] | 1 << x);
                                }
                            }
                            Optional newPoi = containerMaybeHasPoi ? class_7477.method_43989((class_2680)blockState) : Optional.empty();
                            Optional optional = oldPoi = sectionMaybeHasPoi ? class_7477.method_43989((class_2680)old) : Optional.empty();
                            if (!Objects.equals(oldPoi, newPoi)) {
                                if (oldPoi.isPresent()) {
                                    world.method_19494().method_19112((class_2338)blockPos);
                                }
                                if (newPoi.isPresent()) {
                                    world.method_19494().method_19115((class_2338)blockPos, (class_6880)newPoi.get());
                                }
                            }
                        }
                        if (blockState.method_31709()) {
                            int key;
                            CompressedBlockEntity savedBlockEntity;
                            blockPos.method_10103(bx, by, bz);
                            class_2586 blockEntity = chunk.method_12201((class_2338)blockPos, class_2818.class_2819.field_12859);
                            if (blockEntity == null) {
                                blockEntity = ((class_2343)block).method_10123((class_2338)blockPos, blockState);
                                if (blockEntity != null) {
                                    chunk.method_12216(blockEntity);
                                }
                            } else if (blockEntity.method_11017().method_20526(blockState)) {
                                blockEntity.method_31664(blockState);
                                chunk.method_31723(blockEntity);
                            } else {
                                chunk.method_12041((class_2338)blockPos);
                                blockEntity = ((class_2343)block).method_10123((class_2338)blockPos, blockState);
                                if (blockEntity != null) {
                                    chunk.method_12216(blockEntity);
                                }
                            }
                            if (blockEntity == null || blockEntityChunkMap == null || (savedBlockEntity = (CompressedBlockEntity)blockEntityChunkMap.get((short)(key = x | y << 4 | z << 8))) == null) continue;
                            VersionUtils.helperLoadBlockEntity(blockEntity, savedBlockEntity.decompress(), (class_7225.class_7874)world.method_30349());
                            sectionChanged = true;
                            continue;
                        }
                        if (!old.method_31709()) continue;
                        chunk.method_12041((class_2338)blockPos);
                    }
                }
            }
            boolean nowHasOnlyAir = section.method_38292();
            if (hasOnlyAir != nowHasOnlyAir) {
                world.method_14178().method_17293().method_15551(class_4076.method_18676((int)cx, (int)cy, (int)cz), nowHasOnlyAir);
            }
            if (sectionChanged) {
                ((ServerLevelExt)world).axiom$markChunkDirty(cx, cz);
                chunk.method_12008(true);
            }
            if (!relightStarlight) continue;
            ((ServerLevelExt)world).axiom$relightChunkStarlight(cx, cz);
        }
    }

    private static void applyBiomeBufferServer(BiomeBuffer biomeBuffer, class_3218 world) {
        HashSet changedChunks = new HashSet();
        int minSection = world.method_32891();
        int maxSection = world.method_31597();
        Optional registryOptional = world.method_30349().method_33310(class_7924.field_41236);
        if (registryOptional.isEmpty()) {
            return;
        }
        class_2378 registry = (class_2378)registryOptional.get();
        biomeBuffer.forEachEntry((x, y, z, biome) -> {
            int cy = y >> 2;
            if (cy < minSection || cy >= maxSection) {
                return;
            }
            class_2818 chunk = (class_2818)world.method_8402(x >> 2, z >> 2, class_2806.field_12803, false);
            if (chunk == null) {
                return;
            }
            class_2826 section = chunk.method_38259(cy - minSection);
            class_2841 container = (class_2841)section.method_38294();
            Optional holder = registry.method_40264(biome);
            if (holder.isPresent()) {
                container.method_35321(x & 3, y & 3, z & 3, (Object)((class_6880)holder.get()));
                changedChunks.add(chunk);
            }
        });
        class_3898 chunkMap = world.method_14178().field_17254;
        HashMap<class_3222, List> map = new HashMap<class_3222, List>();
        for (class_2818 chunk : changedChunks) {
            chunk.method_12008(true);
            class_1923 chunkPos = chunk.method_12004();
            for (class_3222 serverPlayer2 : chunkMap.method_17210(chunkPos, false)) {
                map.computeIfAbsent(serverPlayer2, serverPlayer -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((serverPlayer, list) -> serverPlayer.field_13987.method_14364((class_2596)class_8212.method_49685((List)list)));
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundSetBuffer::read);
    }
}

